-- events for main menu

timer = 0;

function OnLoad ()
	SetProperty ("/:enter_trans_duration", 0.4);
	SetProperty ("/:leave_trans_duration", 0.4);
	CacheSound ("ui/sfx/panel_move.ogg");
	CacheSound ("music/trophy.ogg");
end;


old_music_volume = 0.8;

function OnEnter ()
	PlaySound ("ui/sfx/panel_move.ogg");
	PlaySound ("music/trophy.ogg");

	local x = GetProperty ("trophy_bm:static_position.x");	
	local y = GetProperty ("trophy_bm:static_position.y");	
	SpawnFX ("fxs/hammer-hit.lua", x, y, 0, 1.27);
	
	old_music_volume = GetVar ("MusicVolume");

	SetMusicVolume (0.1 * old_music_volume);
	timer = 0;

end;

function OnLeave ()
	SetMusicVolume (old_music_volume);
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
	    	PopScreen ();
		return;
	end;

end;


function clamp (value, min, max)
	value = math.min (value, max);
	value = math.max (value, min);
	return value;
end;

function OnUpdate (tdelta)

	timer = timer + tdelta;

	akey = GetActiveScreenAnimKey ();

	local trans = math.sin (0.5*math.pi*GetActiveScreenTransPhase ());
	
	local scale = 2.5-4*timer;
	if (scale < 1) then
		scale = 1;
	end;
	
	local scale_mod = math.sin (clamp (2.0*timer-1.5, 0, 1) * math.pi);
	
	SetProperty ("trophy_bm:scale", scale + scale_mod);
	SetProperty ("trophy_bm:position_offset.y", (scale-1)*60);
	SetProperty ("trophy_bm:alpha", trans* math.max (4-scale, 1));

	local star_scale = 0.75 + math.sin (trans * math.pi) + 0.3 * math.max (2-scale, 1) + 0.8 * scale_mod;
  SetProperty ("trophy_star:scale", star_scale);
  SetProperty ("trophy_star2:scale", 0.8 * star_scale);

  SetProperty ("trophy_star:angle", timer);
  SetProperty ("trophy_star2:angle", math.sin(timer));
    
  SetProperty ("trophy_star:alpha", trans * 0.8);
  SetProperty ("trophy_star2:alpha", trans * 0.8);

  SetProperty ("title:scale", clamp (2.5-5*timer, 1, 4));
  SetProperty ("trophy_name:scale", clamp (2.5-5*(timer-0.2), 1, 4));
  SetProperty ("trophy_desc:scale", clamp (2.5-5*(timer-0.4), 1, 4));

  SetProperty ("title:alpha", clamp (3-GetProperty ("title:scale"), 0, 1));
  SetProperty ("trophy_name:alpha", clamp (3-GetProperty ("trophy_name:scale"), 0, 1));
  SetProperty ("trophy_desc:alpha", clamp (3-GetProperty ("trophy_desc:scale"), 0, 1));
  
	--trans = math.sin (0.5*math.pi * trans);
	--SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", 0.7 * trans);

end;

function OnDraw ()

end;
